/*

  File RK2.ccp:

  Calcola il singolo step dell'evoluzione temporale di una equazione 
  tramite uno schema Runge-Kutta al secondo ordine.

*/


#include "RK2.h"


// Costruttore della classe RK2

RK2::RK2( int Neq, double * y0 )
{
  N = Neq;
  y = new double[ N ];
  dy = new double[ N ];
  ys = new double[ N ];
  setValue( y0 );
}


// Distruttore della classe

RK2::~RK2( )
{
  delete [] y;
  delete [] dy;
  delete [] ys;
}


// Funzione setValue: inizializza il vettore delle incognite con la condizione iniziale

void RK2::setValue( double * y0 )
{
  for ( int i = 0; i < N; i++ ) y[i] = y0[i];
}


// Funzione getValue: restituisce il valore della variabile al tempo corrente

void RK2::getValue( double * sol )
{
  for ( int i = 0; i < N; i++ ) sol[i] = y[i];
}


// Funzione stepRK2: esegue il singolo step Runge-Kutta
// Nota: la funzione calcola il secondo membro chiamando la funzione dydt che deve essere implementata nel main!

void RK2::stepRK2( double t, double dt )
{
  dydt( N, t, y, dy );
  for ( int i = 0; i < N; i++ ) ys[i] = y[i] + 0.5 * dt * dy[i];
  double ts = t + 0.5 * dt;
  dydt( N, ts, ys, dy );
  for ( int i = 0; i < N; i++ ) y[i] = y[i] + dt * dy[i];
}
