/*

  Programma Osc_forzato.ccp:
  integra l'equazione del moto di un oscillatore smorzato e forzato.
  Equazioni:

  d x / dt = v
  d v / dt = -2 * gamma * v - w^0 x + F * cos( w * t )

 */

#include <iostream>
#include <fstream>
#include <cmath>
using namespace std;

#include "RK2.h"


// Variabli globali (parametri dell'equazione, da utilizzare in dydt!)

double gam, w0, F, w;


/*

  Programma principale

*/

int main()
{

  cout << "Programma che integra l'equazione del moto di un oscillatore smorzato e forzato" << endl;
  cout << "con uno schema di Runge-Kutta al secondo ordine." << endl;

  int Neq = 2;

  cout << "Inserire dt, Tend, Tprint: ";
  double dt, Tend, Tprint;
  cin >> dt >> Tend >> Tprint;

  long Nend   = long( Tend / dt );
  long Nprint = long( Tprint / dt );

  cout << "Inserire il valore di gamma, w0, F, w: ";
  cin >> gam >> w0 >> F >> w;

  cout << "Inserire le condizioni iniziali x, v: ";
  double y[Neq];
  cin >> y[0] >> y[1];

  RK2 soluzione = RK2( Neq, y );

  cout << "Nome del file di output: ";
  char nfile[256];
  cin >> nfile;

  double tc = 0.0, tn;

  // Apertura del file di output e scrittura condizioni iniziali

  ofstream fout;
  fout.open( nfile );
  fout.precision( 15 );
  fout << "#   t     x    v" << endl;
  fout << tc;
  for ( int i = 0; i < Neq; i++ ) fout << "   " << y[i];
  fout << endl;

  // Ciclo temporale

  for ( long n = 1; n <= Nend; n++ )
    {

      tc = ( n - 1 ) * dt;

      // Avanza di un passo lo schema

      soluzione.stepRK2( tc, dt );
      tn = n * dt;

      // Stampa ogni Tprint intervalli di stampa

      if ( ( n % Nprint ) == 0 )
	{
	  soluzione.getValue( y );
	  fout << tn;
	  for ( int i = 0; i < Neq; i++ ) fout << "   " << y[i];
	  fout << endl;
	}

    }

  fout.close();

}


// Funzione dydt: calcola il secondo membro dell'equazione

void dydt( int Neq, double t, double * y, double * dy )
{
  dy[0] = y[1];
  dy[1] = - gam * y[1] - w0 * w0 * y[0] + F * cos( w * t );
}
